#ifndef Functions_h
#define Functions_h
#include "Exceptins.h"
#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <map>
#include "Structure.h"

void Fill_File(const std::string& filePath){
    std::ofstream bFile(filePath, std::ios::ate | std::ios::binary);
    if(!bFile.is_open()){
        throw PathError();
    }
    bool flag = true;
    BAccount New;
    
    while(flag){
        std::cin >> New;
        
        bFile.write(reinterpret_cast<const char*>(&New), sizeof(BAccount));
        
        std::cout << "1. I want to create one more account" << std::endl;
        std::cout << "0. End" << std::endl;
        std::cin >> flag;
    }
}

void Create_Map(std::map<int, BAccount>& map, const std::string& bFilePath) {
    std::ifstream bFile(bFilePath, std::ios::binary);
    if (!bFile.is_open()) {
        throw PathError();
    }

    BAccount BAnew;
    while (bFile.read(reinterpret_cast<char*>(&BAnew), sizeof(BAccount))) {
        map.insert(std::make_pair(BAnew.number, BAnew));
    }
}

void To_txt(const std::string& bFilePath, const std::string& tFilePath) {
    std::map<int, BAccount> map;
    Create_Map(map, bFilePath);

    std::ofstream tFile(tFilePath);
    if (!tFile.is_open()) {
        throw PathError();
    }

    tFile << std::setw(14) << "Acconunt number" << std::setw(5) << "|" <<
            std::setw(12) << "Code" << std::setw(6) << "|" <<
            std::setw(10) << "Surname" << std::setw(6) << "|" <<
            std::setw(9) << "Money" << std::setw(6) << "|" <<
            std::setw(16) << "Creation date" << std::setw(6) << "|" <<
            std::setw(18) << "Interest rate" << std::setw(6) << std::endl;
    
    for (const auto& iter : map) {
        tFile << std::setw(14) << iter.second.number << std::setw(6) << "|" <<
                std::setw(12) << iter.second.code << std::setw(6) << "|" <<
                std::setw(10) << iter.second.surname << std::setw(6) << "|" <<
                std::setw(9) << iter.second.sum << std::setw(6) << "|" <<
                std::setw(16) << iter.second.creationDate << std::setw(6) << "|" <<
                std::setw(18) << iter.second.interest << std::setw(6) << std::endl;
    }
    std::cout << "File was successfully converted" << std::endl;
}

void Delete_Account(int accNum, const std::string& bFilePath) {
    std::map<int, BAccount> map;
    Create_Map(map, bFilePath);
    map.erase(accNum);
    std::ofstream bFile(bFilePath, std::ios::binary | std::ios::trunc);
    if (!bFile.is_open()) {
        throw PathError();
    }
    for (const auto& iter : map) {
        bFile.write(reinterpret_cast<const char*>(&iter.second), sizeof(BAccount));
    }
}

void Replace_Account(int accNum, const BAccount& acc, const std::string& bFilePath) {
    std::map<int, BAccount> map;
    Create_Map(map, bFilePath);
    std::ofstream bFile(bFilePath, std::ios::binary | std::ios::trunc);
    if (!bFile.is_open()) {
        throw PathError();
    }
    map[accNum] = acc;
    for (const auto& iter : map) {
        bFile.write(reinterpret_cast<const char*>(&iter.second), sizeof(BAccount));
    }
}

void Search_by_Number(const int num, const std::string& mainBPath, const std::string& newBPath)
{
    std::map<int, BAccount> map;
    Create_Map(map, mainBPath);
    std::vector<BAccount> res;

    for (const auto& iter : map) {
        if (iter.second.number == num) res.push_back(iter.second);
    }

    std::ofstream newFile(newBPath, std::ios::binary | std::ios::trunc);
    if (!newFile.is_open()) {
        throw PathError();
    }
    for (const auto& iter : res) {
        newFile.write(reinterpret_cast<const char*>(&iter), sizeof(BAccount));
    }
}

void Search_by_Code(const long AccCode, const std::string& mainBPath, const std::string& newBPath)
{
    std::map<int, BAccount> map;
    Create_Map(map, mainBPath);
    std::vector<BAccount> res;

    for (const auto& iter : map) {
        if (iter.second.code == AccCode) res.push_back(iter.second);
    }

    std::ofstream newFile(newBPath, std::ios::binary | std::ios::trunc);
    if (!newFile.is_open()) {
        throw PathError();
    }
    for (const auto& iter : res){
        newFile.write(reinterpret_cast<const char*>(&iter), sizeof(BAccount));
    }
}

void Search_by_Surname(const std::string& surn, const std::string& mainBPath, const std::string& newBPath)
{
    std::map<int, BAccount> map;
    Create_Map(map, mainBPath);
    std::vector<BAccount> res;

    for (const auto& elem : map) {
        if (elem.second.surname == surn) res.push_back(elem.second);
    }

    std::ofstream newFile(newBPath, std::ios::binary | std::ios::trunc);
    if (!newFile.is_open()) {
        throw PathError();
    }
    for (const auto& iter : res){
        newFile.write(reinterpret_cast<const char*>(&iter), sizeof(BAccount));
    }
}


#endif
